'********************************************************************************
'
'                       C O P Y R I G H T  (c) 2002
'               N O R T H E R N    D Y N A M I C   I N C.
'                           All Rights Reserved.
'   ........................................................................
'   This sample code is provided by Software Toolbox solely to assist in
'   understanding the use of the SLIK OPC Data Access ActiveX Control. This
'   code is provided as-is and without warranty or support of any sort.
'
'********************************************************************************
'
'   Project:        SLIK OPC Data Access ActiveX Control
'
'   Description:    This sample server application is based on Software Toolbox's
'                   Simple Language Independent Toolkit (SLIK) for creating OPC
'                   data access servers. This implementation illustrates the use
'                   of various features of the SLIK ActiveX Control.
'
'   Revision:
'       02-03-27    gmg     Initial release.
'
'********************************************************************************

Option Strict Off
Option Explicit On 

Imports NDI.SLIKDA.Interop
Imports System.Runtime.InteropServices

Module mdlSLIK
    ' Range of valid values for server statistics sample periods (in milliseconds)
    Public Const c_nMinStatSamplePeriod As Integer = 100
    Public Const c_nMaxStatSamplePeriod As Integer = 60000

    ' Range of valid values for minimum group update period (in milliseconds)
    Public Const c_nMinGroupMinUpdatePeriod As Integer = 10
    Public Const c_nMaxGroupMinUpdatePeriod As Integer = 60000

    ' SLIK Server Statistics
    Public Const c_nStatSamplePeriod As Short = 1
    Public Const c_nStatClients As Short = 2
    Public Const c_nStatGroups As Short = 3
    Public Const c_nStatItems As Short = 4
    Public Const c_nStatReads As Short = 5
    Public Const c_nStatWrites As Short = 6
    Public Const c_nStatChanges As Short = 7
    Public Const c_nStatLogons As Short = 8

    Public Const c_sStatSamplePeriod As String = "SAMPLE_PERIOD"
    Public Const c_sStatClients As String = "NUM_CLIENTS"
    Public Const c_sStatGroups As String = "NUM_GROUPS"
    Public Const c_sStatItems As String = "NUM_ITEMS"
    Public Const c_sStatReads As String = "NUM_READS_PER_PD"
    Public Const c_sStatWrites As String = "NUM_WRITES_PER_PD"
    Public Const c_sStatChanges As String = "NUM_CHG_PER_PD"

    '********************************************************************************
    ' Description:      Create the item namespace for this server. The items will be
    '                   organized by access rights and data type. The item tags will
    '                   make use of the SLIK server Namespace Delimiter property to
    '                   create a hierarchial namespace.
    '
    ' Parameters:
    '   In:             SLIKServer - the instance of the SLIK server
    '   Out:            None
    '
    ' Return Value:     True - namespace created successfully
    '                   False - error occurred
    '********************************************************************************
    Public Function InitNamespace(ByRef OpcServer As NDI.SLIKDA.Interop.SLIKServer, ByVal f As frmMain) As Boolean

        Const nTagsPerLeafFolder As Short = 10

        Dim nAccess As Integer
        Dim nIndex As Short
        Dim Tag As NDI.SLIKDA.Interop.ISLIKTag
        Dim Tags As NDI.SLIKDA.Interop.ISLIKTags

        On Error GoTo errHandler

        Tags = OpcServer.SLIKTags
        '
        ' Create a set of tags that will change in value over time.
        '
        nAccess = NDI.SLIKDA.Interop.AccessPermissionsEnum.sdaReadAccess

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.BOOL.tag" & VB6.Format(nIndex, "00"), nAccess, True, NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.UI1.tag" & VB6.Format(nIndex, "00"), nAccess, CByte(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.I2.tag" & VB6.Format(nIndex, "00"), nAccess, CShort(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.I4.tag" & VB6.Format(nIndex, "00"), nAccess, CInt(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.R4.tag" & VB6.Format(nIndex, "00"), nAccess, CSng(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.R8.tag" & VB6.Format(nIndex, "00"), nAccess, CDbl(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.BSTR.tag" & VB6.Format(nIndex, "00"), nAccess, CStr(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.DATE.tag" & VB6.Format(nIndex, "00"), nAccess, System.DateTime.FromOADate(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("src.CY.tag" & VB6.Format(nIndex, "00"), nAccess, New System.Runtime.InteropServices.CurrencyWrapper(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        '
        ' Create a set of tags that any OPC client may change.
        '
        nAccess = NDI.SLIKDA.Interop.AccessPermissionsEnum.sdaReadAccess + NDI.SLIKDA.Interop.AccessPermissionsEnum.sdaWriteAccess

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.BOOL.tag" & VB6.Format(nIndex, "00"), nAccess, True, NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.UI1.tag" & VB6.Format(nIndex, "00"), nAccess, CByte(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.I2.tag" & VB6.Format(nIndex, "00"), nAccess, CShort(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.I4.tag" & VB6.Format(nIndex, "00"), nAccess, CInt(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.R4.tag" & VB6.Format(nIndex, "00"), nAccess, CSng(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.R8.tag" & VB6.Format(nIndex, "00"), nAccess, CDbl(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.BSTR.tag" & VB6.Format(nIndex, "00"), nAccess, CStr(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.DATE.tag" & VB6.Format(nIndex, "00"), nAccess, System.DateTime.FromOADate(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        For nIndex = 1 To nTagsPerLeafFolder
            Tag = Tags.Add("trg.CY.tag" & VB6.Format(nIndex, "00"), nAccess, New System.Runtime.InteropServices.CurrencyWrapper(nIndex), NDI.SLIKDA.Interop.QualityStatusEnum.sdaGood)
        Next nIndex

        InitNamespace = True

        Exit Function

errHandler:
        Call f.ReportEvent(Err.Description, "Namespace initialization error")
        InitNamespace = False
        Exit Function

    End Function

    '********************************************************************************
    ' Description:      Convert the server status value to a string.
    '
    ' Parameters:
    '   In:             nStatus - Server status
    '   Out:            None
    '
    ' Return Value:     Text equivalent (or empty string if no match found)
    '********************************************************************************
    Public Function ServerStatusToStr(ByRef nStatus As NDI.SLIKDA.Interop.ServerStatusEnum) As String

        Select Case nStatus
            Case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusFailed
                ServerStatusToStr = "Failed"
            Case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusNoConfig
                ServerStatusToStr = "No Configuration"
            Case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusRunning
                ServerStatusToStr = "Running"
            Case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusSuspended
                ServerStatusToStr = "Suspended"
            Case NDI.SLIKDA.Interop.ServerStatusEnum.sdaStatusTest
                ServerStatusToStr = "Test"
            Case Else
                ServerStatusToStr = "UNKNOWN!"
        End Select

    End Function
End Module